//
//  Creating_TimersAppDelegate.m
//  Creating Timers
//
//  Created by Vandad Nahavandipoor on 14/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Creating_TimersAppDelegate.h"

@implementation Creating_TimersAppDelegate

@synthesize window = _window;
@synthesize paintingTimer;

/* 1 */
//- (void) paint:(NSTimer *)paramTimer{
//  /* Kod odpowiedzialny za rysowanie. */
//  NSLog(@"Rysowanie");
//}
//
//- (void) startPainting{
//  
//  self.paintingTimer = [NSTimer 
//                        scheduledTimerWithTimeInterval:1.0
//                        target:self
//                        selector:@selector(paint:) 
//                        userInfo:nil
//                        repeats:YES];
//  
//}
//
//- (void) stopPainting{
//  if (self.paintingTimer != nil){
//    [self.paintingTimer invalidate];    
//  }
//}
//
//- (void)applicationWillResignActive:(UIApplication *)application{
//  [self stopPainting];
//}
//
//- (void)applicationDidBecomeActive:(UIApplication *)application{
//  [self startPainting];
//}

/* 2 */
//- (void) paint:(NSTimer *)paramTimer{
//  /* Kod odpowiedzialny za rysowanie. */
//  NSLog(@"Rysowanie");
//}
//
//- (void) startPainting{
//  
//  /* To jest selektor metody, która ma zostać wywołana. */
//  SEL selectorToCall = @selector(paint:);
//  
//  /* Utworzenie sygnatury metody na podstawie selektora. Wiemy, że selektor znajduje się w klasie bieżącej, więc utworzenie sygnatury metody jest bardzo łatwe. */
//  NSMethodSignature *methodSignature = 
//    [[self class] instanceMethodSignatureForSelector:selectorToCall];
//  
//  /* Przygotowanie wywołania na podstawie sygnatury metody. Wspomniane wywołanie jest potrzebne do utworzenia harmonogramu licznika czasu. */
//  NSInvocation *invocation = 
//    [NSInvocation invocationWithMethodSignature:methodSignature];
//  [invocation setTarget:self];
//  [invocation setSelector:selectorToCall];
//  
//  /* Uruchomienie licznika czasu. */
//  self.paintingTimer = [NSTimer scheduledTimerWithTimeInterval:1.0
//                                                    invocation:invocation
//                                                       repeats:YES];
//  
//}
//
//- (void) stopPainting{
//  if (self.paintingTimer != nil){
//    [self.paintingTimer invalidate];    
//  }
//}
//
//- (void)applicationWillResignActive:(UIApplication *)application{
//  [self stopPainting];
//}
//
//- (void)applicationDidBecomeActive:(UIApplication *)application{
//  [self startPainting];
//}

/* 3 */
//- (void) paint:(NSTimer *)paramTimer{
//  /* Kod odpowiedzialny za rysowanie. */
//  NSLog(@"Rysowanie");
//}
//
//- (void) startPainting{
//  
//  self.paintingTimer = [NSTimer timerWithTimeInterval:1.0
//                                               target:self
//                                             selector:@selector(paint:)
//                                             userInfo:nil
//                                              repeats:YES];
//  
//  /* Miejsce na właściwy kod wykonujący określone zadanie. Gdy wszystko będzie przygotowane, należy użyć metody egzemplarza o nazwie addTimer:forMode klasy NSRunLoop w celu dodania licznika czasu z harmonogramem do pętli działania. */
//  
//  [[NSRunLoop currentRunLoop] addTimer:self.paintingTimer
//                               forMode:NSDefaultRunLoopMode];
//  
//}
//
//- (void) stopPainting{
//  if (self.paintingTimer != nil){
//    [self.paintingTimer invalidate];    
//  }
//}
//
//- (void)applicationWillResignActive:(UIApplication *)application{
//  [self stopPainting];
//}
//
//- (void)applicationDidBecomeActive:(UIApplication *)application{
//  [self startPainting];
//}

/* 4 */
- (void) paint:(NSTimer *)paramTimer{
  /* Kod odpowiedzialny za rysowanie. */
  NSLog(@"Rysowanie");
}

- (void) startPainting{
  
  /* To jest selektor metody, która ma zostać wywołana. */
  SEL selectorToCall = @selector(paint:);
  
  /* Utworzenie sygnatury metody na podstawie selektora. Wiemy, że selektor znajduje się w klasie bieżącej,
   więc utworzenie sygnatury metody jest bardzo łatwe. */
  NSMethodSignature *methodSignature = 
  [[self class] instanceMethodSignatureForSelector:selectorToCall];
  
  /* Przygotowanie wywołania na podstawie sygnatury metody.
   Wspomniane wywołanie jest potrzebne do utworzenia harmonogramu licznika czasu. */
  NSInvocation *invocation = 
  [NSInvocation invocationWithMethodSignature:methodSignature];  
  
  [invocation setTarget:self];
  [invocation setSelector:selectorToCall];
  
  self.paintingTimer = [NSTimer timerWithTimeInterval:1.0
                                           invocation:invocation 
                                              repeats:YES];
  
  /* Miejsce na właściwy kod wykonujący określone zadanie. Gdy wszystko będzie przygotowane,
   należy użyć metody egzemplarza o nazwie addTimer:forMode klasy NSRunLoop 
   w celu dodania licznika czasu z harmonogramem do pętli działania */
  
  [[NSRunLoop currentRunLoop] addTimer:self.paintingTimer
                               forMode:NSDefaultRunLoopMode];
  
}

- (void) stopPainting{
  if (self.paintingTimer != nil){
    [self.paintingTimer invalidate];    
  }
}

- (void)applicationWillResignActive:(UIApplication *)application{
  [self stopPainting];
}

- (void)applicationDidBecomeActive:(UIApplication *)application{
  [self startPainting];
}


- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
